(function(){
    
    'use strict'  
    var nvJsonStore = require('node-json-db');
    var db = new nvJsonStore(process.env.ProgramData + '\\NVIDIA Corporation\\Downloader\\config\\clientsettings', true, false);
    
    function getKeyForStore(k){
        var tmp = k.replace(/\./g, "/");
        return tmp;
    }
            
    module.exports = {
        getValue: function(k){
            try{
                var value = db.getData("/"+getKeyForStore(k));
            }catch(e){
                value = "";
            }
            return value;
        },

        updateValue: function(k, v){
            //if not present, it will create new
			try{
				db.push("/"+getKeyForStore(k), v);
			}catch(e){
				return;
			}
        },

        deleteValue: function(k){
			try{
				db.delete("/"+getKeyForStore(k));
			}catch(e){
				return;
			}
        }
    }    
})();